<?php
/* --------------------------------------------------------------
   FetchedSpecificWithdrawal.php 2020-03-30
   Gambio GmbH
   http://www.gambio.de
   Copyright (c) 2020 Gambio GmbH
   Released under the GNU General Public License (Version 2)
   [http://www.gnu.org/licenses/gpl-2.0.html]
   --------------------------------------------------------------
*/

declare(strict_types=1);

namespace Gambio\Admin\Withdrawal\Events;

use Gambio\Admin\Withdrawal\Interfaces\Withdrawal;

/**
 * Class FetchedSpecificWithdrawal
 *
 * @package Gambio\Admin\Withdrawal\Events
 */
class FetchedSpecificWithdrawal
{
    /**
     * @var Withdrawal
     */
    private $withdrawal;
    
    
    /**
     * FetchedSpecificWithdrawalEvent constructor.
     *
     * @param Withdrawal $withdrawal
     */
    private function __construct(Withdrawal $withdrawal)
    {
        $this->withdrawal = $withdrawal;
    }
    
    
    /**
     * @param Withdrawal $withdrawal
     *
     * @return FetchedSpecificWithdrawal
     */
    public static function create(Withdrawal $withdrawal): FetchedSpecificWithdrawal
    {
        return new self($withdrawal);
    }
    
    
    /**
     * @return Withdrawal
     */
    public function withdrawal(): Withdrawal
    {
        return $this->withdrawal;
    }
    
    
    /**
     * @param Withdrawal $withdrawal
     */
    public function replaceWithdrawal(Withdrawal $withdrawal): void
    {
        $this->withdrawal = $withdrawal;
    }
}